#ifndef DATABASE_FIELD_NAMES_H
#define DATABASE_FIELD_NAMES_H

// List of field names for columns in database. Note that these
// may appear on the user interface, e.g., if we get around to letting
// the user create his or her own conditions from scratch.
// so we should probably make them readable for the user.
// currently using record type to indicate which experimenter/rat added record
// type 1 = database load
// type 2 = stupid exp/rat
// type 3 = RATNET/symmetry
// type 4 = identity match

#define		DBFLD_RECORD_TYPE		"Record Type"
#define		DBFLD_RAT_NUMBER		"Rat Number"
#define		DBFLD_ARM_NUMBER		"Arm Number"

// Did the arm contain food when the rat entered?
#define		DBFLD_CONTAINED_FOOD	"Contained Food" // boolean represented by int16

// Did the rat consume food upon entering an arm that contained food?
#define		DBFLD_CONSUMED_FOOD		"Consumed Food" // boolean represented by int16

#define		DBFLD_TRIAL_TYPE		"Trial Type"
#define		DBFLD_TRIAL_NUMBER		"Trial Number"

// Special- This is not really a field name, but an identifier used to tell the database
// to substitute the rat number of the rat currently on the maze for this.
#define		DBFLD_CURRENT_RAT		"Current Rat"

// CGP, 11/12/00
#define		DBFLD_RAT_VIEW0			"Rat View 0"
#define		DBFLD_RAT_VIEW1			"Rat View 1"
#define		DBFLD_RAT_VIEW2			"Rat View 2"
#define		DBFLD_RAT_VIEW3			"Rat View 3"
#define		DBFLD_RAT_VIEW4			"Rat View 4"
#define		DBFLD_RAT_VIEW5			"Rat View 5"
#define		DBFLD_RAT_VIEW6			"Rat View 6"
#define		DBFLD_RAT_VIEW7			"Rat View 7"
#define		DBFLD_RAT_VIEW8			"Rat View 8"

// CGP, 11/12/00-- indicate a type within a type
#define		DBFLD_RECORD_SUB_TYPE	"Record Sub Type"

// CGP, 11/12/00-- vector distances from alternative views
#define		DBFLD_DIST_ALT1			"Dist From Alternative 1"
#define		DBFLD_DIST_ALT2			"Dist From Alternative 2"

#define		DBFLD_TRIAL_PHASE		"Trial Phase"

#endif
